function Data = Calculations()

%{
This m-file belongs to the article 'The role of the electrolyte identity on
electrochemical CO2 conversion in the absence of mass transfer limitations'
Authors: Anne Sustronk (1,2) , Nieck E. Benes (1) , Guido Mul (2)
(1) Films in Fluids, Department of Science and Technology, University of 
Twente, Enschede, The Netherlands
(2) Photocatalytic Synthesis Group, Department of Science and Technology, 
University of Twente, Enschede, The Netherlands

The file is used to provide for the input required to plot Figures 1 and 4 
of the article.

The next files are required to execute this file: ConstantPotential.m, 
CalH2Data.txt, CalCOData.txt, CalFADataFeb22.txt, and CalErr.m

This file is used by Fig1andFig4.m

Note that the file location in ConstantPotential.m (lines 32, 56, 61 
and 66) should be added before execution.

Version date m-file: Feb 22, 2023
%}

warning('off','MATLAB:table:ModifiedAndSavedVarnames')

% Create variable names
VarName = ['Pot1'; 'Pot2'; 'Pot3'; 'Pot4'; 'Pot5'; 'Pot6'; 'Pot7'; 'Pot8'; 'Pot9'];

%% NaHCO3 results
SubFolder1 = {'\-1.1 V CO2 flow';
    '\-1.2 V CO2 flow';
    '\-1.3 V CO2 flow';
    '\-1.4 V CO2 flow';
    '\-1.5 V CO2 flow';
    '\-1.6 V CO2 flow';
    '\-1.7 V CO2 flow';
    '\-1.8 V CO2 flow';
    '\-1.9 V CO2 flow'};

% Data from potentiostat
FileNameEC1 = {' -1.1 V CO2 flow.txt';
    ' -1.2 V CO2 flow.txt';
    ' -1.3 V CO2 flow.txt';
    ' -1.4 V CO2 flow.txt';
    ' -1.5 V CO2 flow.txt';
    ' -1.6 V CO2 flow.txt';
    ' -1.7 V CO2 flow.txt';
    ' -1.8 V CO2 flow.txt';
    ' -1.9 V CO2 flow.txt'};

% Potential set during experiment
ESet1 = [-1.1; -1.2; -1.3; -1.4; -1.5; -1.6; -1.7; -1.8; -1.9];

% Geometric area and corresponding error
AreaNa = [0.38; 0.45; 0.38; 0.44; 0.38; 0.45; 0.44; 0.37; 0.45];
AreaErrNa = [0.046; 0.045; 0.046; 0.045; 0.046; 0.045; 0.045; 0.046; 0.045];

% Call ConstantPotential.m
Data.NaHCO3 = ConstantPotential('\NaHCO3', SubFolder1, FileNameEC1, AreaNa, AreaErrNa, ESet1, VarName);

%% KHCO3 results

SubFolder2 = {'\-1.0 V CO2 flow';
    '\-1.1 V CO2 flow';
    '\-1.2 V CO2 flow';
    '\-1.3 V CO2 flow';
    '\-1.4 V CO2 flow';
    '\-1.5 V CO2 flow';
    '\-1.6 V CO2 flow';
    '\-1.7 V CO2 flow';
    '\-1.8 V CO2 flow'};

% Data from potentiostat
FileNameEC2 = {' -1.0 V CO2 flow.txt';
    ' -1.1 V CO2 flow.txt';
    ' -1.2 V CO2 flow.txt';
    ' -1.3 V CO2 flow.txt';
    ' -1.4 V CO2 flow.txt';
    ' -1.5 V CO2 flow.txt';
    ' -1.6 V CO2 flow.txt';
    ' -1.7 V CO2 flow.txt';
    ' -1.8 V CO2 flow.txt'};

% Potential set during experiment
ESet2 = [-1.0; -1.1; -1.2; -1.3; -1.4; -1.5; -1.6; -1.7; -1.8];

% Geometric area and corresponding error
AreaK = [0.51; 0.51; 0.64; 0.51; 0.51; 0.64; 0.51; 0.51; 0.64];
AreaErrK = [0.047; 0.047; 0.048; 0.047; 0.047; 0.048; 0.047; 0.047; 0.048];

% Call ConstantPotential.m
Data.KHCO3 = ConstantPotential('\KHCO3', SubFolder2, FileNameEC2, AreaK, AreaErrK, ESet2, VarName);

%% CsHCO3 results

% The CsHCO3 experiments follow the same structure as the KHCO3 experiments
% and no new SubFolder is defined

% Area and area error
AreaCs = [0.42; 0.35; 0.42; 0.42; 0.35; 0.42; 0.42; 0.35; 0.42];
AreaErrCs = [0.045; 0.044; 0.044; 0.045; 0.044; 0.044; 0.045; 0.044; 0.044];

% Call ConstantPotential.m
Data.CsHCO3 = ConstantPotential('\CsHCO3', SubFolder2, FileNameEC2, AreaCs, AreaErrCs, ESet2, VarName);

%% K2SO4 results

% The K2SO4 experiments follow the same structure as the KHCO3 experiments
% and no new SubFolder is defined

% Geometric area and corresponding error
AreaSO4 = [0.38; 0.47; 0.57; 0.38; 0.47; 0.57; 0.38; 0.47; 0.57; ];
AreaErrSO4 = [0.046; 0.047; 0.047; 0.046; 0.047; 0.047; 0.046; 0.047; 0.047];

% Call ConstantPotential.m
Data.K2SO4 = ConstantPotential('\K2SO4', SubFolder2, FileNameEC2, AreaSO4, AreaErrSO4, ESet2, VarName);

%% KH2PO4 results

% The KH2PO4 experiments follow the same structure as the NaHCO3 experiments
% and no new SubFolder is defined

% Potential set during experiment
ESetH2PO4 = [-1.1; -1.2; -1.3; -1.4; -1.6; -1.7; -1.8; -1.9];

% Geometric area and corresponding error
AreaH2PO4 = [0.41; 0.43; 0.48; 0.41; 0.48; 0.41; 0.43; 0.48];
AreaErrH2PO4 = [0.045; 0.048; 0.046; 0.045; 0.046; 0.045; 0.048; 0.046];

% Call ConstantPotential.m
Data.KH2PO4 = ConstantPotential('\KH2PO4', [SubFolder1(1:4,:);SubFolder1(6:end,:)], [FileNameEC1(1:4,:); FileNameEC1(6:end,:)], AreaH2PO4, AreaErrH2PO4, ESetH2PO4, [VarName(1:4,:);VarName(6:end,:)]);
    
end

